package com.sap.idm.vds.connector.samplefile.impl;

import java.io.File;

/**
 * Class created to delete files and directories
 * @author I054742
 *
 */
public class FileDelete {
	
	/**
	 * Constructor
	 */
	public FileDelete () {}
	
	/**
	 * This method deletes a file of the file system
	 * @param filePath -> The path of the file to be deleted
	 * @param isDNDirectory -> The type of file according to the DN used
	 * @return -> An integer code indicating if the operation was done successfully or not.
	 * 			  In the case of error the corresponding error code is returned.
	 */
	public int delete (String filePath, boolean isDNDirectory) {
		
		File file = new File(filePath);
		/* If the file does not exist then the corresponding error code is returned */
		if (file.exists()==false) {
			return FileConstants.FILE_NOT_FOUND;
		}
		/* If the file is a directory... */
		if (file.isDirectory()==true) {
			/* The DN file type does not match with the real file type in the system */
			if (isDNDirectory==false) return FileConstants.WRONG_DN_FILE_TYPE;
			/* If the directory contains other directories or files then is not possible to delete it */
			if (file.listFiles().length>0) return FileConstants.PROHIBIT_DELETE_BRANCHES;
		}
		/* If the file is not a directory ...*/
		else {
			/* The DN file type does not match with the real file type in the system */
			if (isDNDirectory) return FileConstants.WRONG_DN_FILE_TYPE;
		}
		int i=0;
		while (i++<1000 && file.delete()==false);
		if (i==1000) return FileConstants.IO_ERROR;
		return FileConstants.SUCCESS;
	}
}
